/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.lpar;

import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.PIVirtualEthernetDataBean;
import com.ibm.hsc.client.PIVirtualSCSIDataBean;
import com.ibm.hsc.client.PIVirtualSerialDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.InfoPanel;
import com.ibm.jcb.RemoteSourceException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.bundles.CommonBundle;
import com.ibm.websm.console.WWorkingDialog;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EWorkingListener;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;
import org.snia.wbem.cim.UnsignedInt16;

public class PIDlparVirtualIOCommitListener
implements TaskActionListener {
    private MOClass m_moclass;
    private String m_lparKey = null;
    private final String DLPAR_BUNDL_NAME = "PIDLPARBundle";
    private final String OS400_PARTITION = "OS400_PARTITION";
    private final String RPA_PARTITION = "RPA_PARTITION";
    private PILPARProfileDataBean m_cimProfileBean;
    private Map m_ethernetAdapters;
    private Map m_serialAdapters;
    private Map m_scsiAdapters;
    private UserTaskManager m_UsrTaskMgr;
    private UserTaskManager m_WarningUTM;
    static /* synthetic */ Class class$com$ibm$websm$etc$EWorkingListener;

    public PIDlparVirtualIOCommitListener(MOXContainerObj mOXContainerObj, PILPARProfileDataBean pILPARProfileDataBean, Map map, Map map2, Map map3, UserTaskManager userTaskManager) {
        this.m_moclass = mOXContainerObj.getMOClass();
        this.m_lparKey = mOXContainerObj.getKey();
        this.m_cimProfileBean = pILPARProfileDataBean;
        this.m_ethernetAdapters = map;
        this.m_serialAdapters = map2;
        this.m_scsiAdapters = map3;
        this.m_UsrTaskMgr = userTaskManager;
    }

    private void debug(String string) {
        if (IDebug.enabled) {
            System.err.println("| VirtualIOCommitListener." + string);
        }
    }

    private boolean isRMCConnectionExist(String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        Object object = this.m_moclass.invokeStaticMethod("isRMCConnectionExist", objectArray);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    private UserTaskManager getWarningUsrTaskMgr() {
        return this.m_WarningUTM;
    }

    private void setWarningUsrTaskMgr(UserTaskManager userTaskManager) {
        this.m_WarningUTM = userTaskManager;
    }

    private void showConfirmationMsg() {
        try {
            AuimlAdapter auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.dlpar.PIDlparConfirmation", "NoRmcVio", null, this.m_UsrTaskMgr);
            UserTaskManager userTaskManager = auimlAdapter.getUserTaskManager();
            this.setWarningUsrTaskMgr(userTaskManager);
            userTaskManager.addTaskActionListener((TaskActionListener)this);
            auimlAdapter.showIt();
        }
        catch (TaskManagerException taskManagerException) {
            this.showInfo(taskManagerException.toString(), null, null);
        }
    }

    private String getPartitionType() throws Exception {
        Object[] objectArray = new Object[]{this.m_lparKey};
        Object object = this.m_moclass.invokeStaticMethod("getPartitionType", objectArray);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    private void saveChanges(Boolean bl) {
        Object[] objectArray;
        UnsignedInt16 unsignedInt16;
        WWorkingDialog wWorkingDialog;
        this.debug("PIDlparVirtualIOCommitListener.actionPerformed()");
        Map map = this.m_cimProfileBean.getVirtualSerialAdapters();
        Map map2 = this.m_cimProfileBean.getVirtualSCSIAdapters();
        Map map3 = this.m_cimProfileBean.getVirtualEthernetAdapters();
        HashMap<UnsignedInt16, PIVirtualEthernetDataBean> hashMap = new HashMap<UnsignedInt16, PIVirtualEthernetDataBean>();
        HashMap<UnsignedInt16, PIVirtualEthernetDataBean> hashMap2 = new HashMap<UnsignedInt16, PIVirtualEthernetDataBean>();
        HashMap<UnsignedInt16, PIVirtualEthernetDataBean> hashMap3 = new HashMap<UnsignedInt16, PIVirtualEthernetDataBean>();
        HashMap<UnsignedInt16, PIVirtualEthernetDataBean> hashMap4 = new HashMap<UnsignedInt16, PIVirtualEthernetDataBean>();
        Hashtable<Integer, HashMap<UnsignedInt16, PIVirtualEthernetDataBean>> hashtable = new Hashtable<Integer, HashMap<UnsignedInt16, PIVirtualEthernetDataBean>>(4);
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            wWorkingDialog = iterator.next();
            unsignedInt16 = (UnsignedInt16)wWorkingDialog.getKey();
            this.debug("Ethernet Slot: " + unsignedInt16);
            if (this.m_ethernetAdapters.containsKey(unsignedInt16)) continue;
            this.debug("Ethernet Slot: " + unsignedInt16);
            objectArray = (PIVirtualEthernetDataBean)wWorkingDialog.getValue();
            hashMap4.put(unsignedInt16, (PIVirtualEthernetDataBean)objectArray);
        }
        this.debug("addEthernetMap : " + hashMap4.toString());
        hashtable.put(new Integer(2), hashMap4);
        iterator = this.m_ethernetAdapters.entrySet().iterator();
        while (iterator.hasNext()) {
            wWorkingDialog = iterator.next();
            unsignedInt16 = (UnsignedInt16)wWorkingDialog.getKey();
            this.debug(" Ethernet Slot: " + unsignedInt16);
            if (map3.containsKey(unsignedInt16)) continue;
            objectArray = (PIVirtualEthernetDataBean)wWorkingDialog.getValue();
            hashMap.put(unsignedInt16, (PIVirtualEthernetDataBean)objectArray);
        }
        iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            wWorkingDialog = iterator.next();
            unsignedInt16 = (UnsignedInt16)wWorkingDialog.getKey();
            this.debug(" SCSI Slot: " + unsignedInt16);
            if (this.m_scsiAdapters.containsKey(unsignedInt16)) continue;
            objectArray = (PIVirtualSCSIDataBean)wWorkingDialog.getValue();
            hashMap3.put(unsignedInt16, (PIVirtualEthernetDataBean)objectArray);
        }
        this.debug("addScsiMap : " + hashMap3.toString());
        hashtable.put(new Integer(3), hashMap3);
        iterator = this.m_scsiAdapters.entrySet().iterator();
        while (iterator.hasNext()) {
            wWorkingDialog = iterator.next();
            unsignedInt16 = (UnsignedInt16)wWorkingDialog.getKey();
            this.debug("SCSI Slot: " + unsignedInt16);
            if (map2.containsKey(unsignedInt16)) continue;
            objectArray = (PIVirtualSCSIDataBean)wWorkingDialog.getValue();
            hashMap.put(unsignedInt16, (PIVirtualEthernetDataBean)objectArray);
        }
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            wWorkingDialog = iterator.next();
            unsignedInt16 = (UnsignedInt16)wWorkingDialog.getKey();
            this.debug("Serial Slot: " + unsignedInt16);
            if (this.m_serialAdapters.containsKey(unsignedInt16)) continue;
            objectArray = (PIVirtualSerialDataBean)wWorkingDialog.getValue();
            hashMap2.put(unsignedInt16, (PIVirtualEthernetDataBean)objectArray);
        }
        this.debug("addSerialMap : " + hashMap2.toString());
        hashtable.put(new Integer(4), hashMap2);
        iterator = this.m_serialAdapters.entrySet().iterator();
        while (iterator.hasNext()) {
            wWorkingDialog = iterator.next();
            unsignedInt16 = (UnsignedInt16)wWorkingDialog.getKey();
            this.debug("Serial Slot: " + unsignedInt16);
            if (map.containsKey(unsignedInt16)) continue;
            objectArray = (PIVirtualSerialDataBean)wWorkingDialog.getValue();
            hashMap.put(unsignedInt16, (PIVirtualEthernetDataBean)objectArray);
        }
        this.debug("remAdaptersMap : " + hashMap.toString());
        hashtable.put(new Integer(1), hashMap);
        if (hashMap2.size() > 0 || hashMap3.size() > 0 || hashMap4.size() > 0 || hashMap.size() > 0) {
            wWorkingDialog = new WWorkingDialog((Frame)new JFrame(), CommonBundle.getMessage((String)"WORKING\u001eCommonBundle\u001e"));
            wWorkingDialog.setProperties("e,i");
            unsignedInt16 = (EWorkingListener)WSessionMgr.getProxy((String)(class$com$ibm$websm$etc$EWorkingListener == null ? (class$com$ibm$websm$etc$EWorkingListener = PIDlparVirtualIOCommitListener.class$("com.ibm.websm.etc.EWorkingListener")) : class$com$ibm$websm$etc$EWorkingListener).getName(), (Object)wWorkingDialog);
            objectArray = new Object[]{this.m_lparKey, hashtable, unsignedInt16, bl};
            try {
                this.m_moclass.invokeStaticMethod("doVirtualIO", objectArray);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
    }

    private void showInfo(String string, String string2, String string3) {
        InfoPanel infoPanel = new InfoPanel(string, string2, string3);
        infoPanel.show();
    }

    private void handleException(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            String string = null;
            if (throwable instanceof RemoteSourceException) {
                RemoteSourceException remoteSourceException = (RemoteSourceException)throwable;
                if ((throwable = remoteSourceException.getSourceException()) instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
                    throwable = invocationTargetException.getTargetException();
                }
            } else if (throwable instanceof PIHscClientException) {
                PIHscClientException pIHscClientException = (PIHscClientException)throwable;
                string = pIHscClientException.getMessage();
            }
            printStream.close();
            byteArrayOutputStream.close();
            if (string == null || string.trim().length() == 0) {
                string = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "294C", "DLPAR  Virtual I/O resources failed");
            }
            this.showInfo(string, null, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        String string = taskActionEvent.getElementName().trim();
        String string2 = taskActionEvent.getActionCommand();
        this.debug("eventName = " + string);
        this.debug("action = " + string2);
        if (string2.equals("continue")) {
            this.saveChanges(new Boolean(true));
            this.m_UsrTaskMgr.dispose();
        } else if (string2.equals("COMPLETE")) {
            this.debug("in complete action");
            String string3 = "";
            try {
                this.debug("getting the partition type");
                string3 = this.getPartitionType();
            }
            catch (Exception exception) {
                this.showInfo(exception.toString(), null, null);
            }
            if ("OS400_PARTITION".equals(string3)) {
                this.saveChanges(new Boolean(true));
                this.m_UsrTaskMgr.dispose();
            } else if ("RPA_PARTITION".equals(string3)) {
                boolean bl = false;
                try {
                    bl = this.isRMCConnectionExist(this.m_lparKey);
                }
                catch (Exception exception) {
                    this.showInfo(exception.toString(), null, null);
                }
                if (!bl) {
                    this.showConfirmationMsg();
                } else {
                    this.saveChanges(new Boolean(false));
                    this.m_UsrTaskMgr.dispose();
                }
            }
        } else if (string2.equals("CANCEL")) {
            this.debug("in cancel");
            if (this.getWarningUsrTaskMgr() != null) {
                this.debug("cancelling the action");
                this.getWarningUsrTaskMgr().dispose();
            } else {
                this.m_UsrTaskMgr.dispose();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

